/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.sceNetInet;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class sceNetResolver
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetResolver");
    private static final String uidPurpose = "sceNetResolver-NetResolver";
    protected HashMap<Integer, ResolverID> RIDs = new HashMap();

    public int checkRid(int rid) {
        if (!this.RIDs.containsKey(rid)) {
            throw new SceKernelErrorException(-2143222776);
        }
        return rid;
    }

    @HLEFunction(nid=-214495647, version=150)
    public int sceNetResolverInit() {
        return 0;
    }

    @HLEFunction(nid=1631066442, version=150)
    public int sceNetResolverTerm() {
        return 0;
    }

    @HLEFunction(nid=608268975, version=150)
    public int sceNetResolverCreate(TPointer32 pRid, TPointer buffer, int bufferLength) {
        int newID = SceUidManager.getNewUid(uidPurpose);
        ResolverID newRID = new ResolverID(newID, true);
        this.RIDs.put(newID, newRID);
        pRid.setValue(newRID.getID());
        return 0;
    }

    @HLEFunction(nid=-1806549495, version=150)
    public int sceNetResolverDelete(@CheckArgument(value="checkRid") int rid) {
        this.RIDs.remove(rid);
        SceUidManager.releaseUid(rid, uidPurpose);
        return 0;
    }

    @HLEFunction(nid=575430468, version=150)
    public int sceNetResolverStartNtoA(@CheckArgument(value="checkRid") int rid, PspString hostname, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 addr, int timeout, int retry) {
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname.getString());
            int resolvedAddress = sceNetInet.bytesToInternetAddress(inetAddress.getAddress());
            addr.setValue(resolvedAddress);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetResolverStartNtoA returning address 0x%08X('%s')", resolvedAddress, sceNetInet.internetAddressToString(resolvedAddress)));
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceNetResolverStartNtoA resolved '%s' into '%s'", hostname.getString(), sceNetInet.internetAddressToString(resolvedAddress)));
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)e);
            return -2143222764;
        }
        return 0;
    }

    @HLEFunction(nid=1654534071, version=150)
    public int sceNetResolverStartAtoN(@CheckArgument(value="checkRid") int rid, int addr, TPointer hostnameAddr, int hostnameLength, int timeout, int retry) {
        try {
            byte[] bytes = sceNetInet.internetAddressToBytes(addr);
            InetAddress inetAddress = InetAddress.getByAddress(bytes);
            String hostName = inetAddress.getHostName();
            hostnameAddr.setStringNZ(hostnameLength, hostName);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetResolverStartAtoN returning host name '%s'", hostName));
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)e);
            return -2143222764;
        }
        return 0;
    }

    @HLEFunction(nid=-2138087325, version=150)
    public int sceNetResolverStop(@CheckArgument(value="checkRid") int rid) {
        ResolverID currentRID = this.RIDs.get(rid);
        if (!currentRID.getIDStatus()) {
            return -2143222774;
        }
        currentRID.stop();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=348225273, version=150)
    public int sceNetResolverStartNtoAAsync() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1430220412, version=150)
    public int sceNetResolverStartAtoNAsync() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1323930456, version=150)
    public int sceNetResolverPollAsync() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=309628601, version=150)
    public int sceNetResolverWaitAsync(Processor processor) {
        return 0;
    }

    protected static class ResolverID {
        private int id;
        private boolean isRunning;

        public ResolverID(int id, boolean running) {
            this.id = id;
            this.isRunning = running;
        }

        public int getID() {
            return this.id;
        }

        public boolean getIDStatus() {
            return this.isRunning;
        }

        public void stop() {
            this.isRunning = false;
        }
    }
}

